/*
 * Code to provide a hexdump of a 6502 binary image for input into
 * the Apple ][ monitor
 *
 * by: Arthur Jerijian     18 October 2000
 */

#include <stdio.h>
#include <stdlib.h>

int main (int argc, char *argv [])
{
	FILE * file;
	int address;
	int i = 0;
	unsigned char cur_byte;

	switch (argc)
	{
		case 2:
			address = 0;
			break;
		case 3:
			address = strtol (argv [2], NULL, 16);
			break;
		default:
			fprintf (stderr,
				 "Usage: %s file <hex_start_address>\n",
				 argv [0]);
			return -1;
			break;
	}

	file = fopen (argv [1], "r");
	if (file == NULL)
	{
		fprintf (stderr, "Unable to open %s for reading!\n",
			 argv [1]);
		return -1;
	}

	printf ("%04x:", address);
	while (!feof (file))
	{
		if (i > 7)
		{
			i = 0;
			address += 8;
			printf ("\n%04x:", address);
		}
		cur_byte = 0;
		fread (&cur_byte, 1, 1, file);
		printf ("%02x ", cur_byte);
		i++;
	}
	printf ("\n");

	fclose (file);
	return 0;
}

